/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public final class IOReactorConfig
implements Cloneable {
    private static final int AVAIL_PROCS = Runtime.getRuntime().availableProcessors();
    private long selectInterval = 1000L;
    private long shutdownGracePeriod = 500L;
    private boolean interestOpQueued = false;
    private int ioThreadCount = AVAIL_PROCS;
    private int soTimeout = 0;
    private boolean soReuseAddress = false;
    private int soLinger = -1;
    private boolean soKeepAlive = false;
    private boolean tcpNoDelay = true;
    private int connectTimeout = 0;
    private int sndBufSize;
    private int rcvBufSize;

    public long getSelectInterval() {
        return this.selectInterval;
    }

    public void setSelectInterval(long selectInterval) {
        if (selectInterval <= 0L) {
            throw new IllegalArgumentException("Select internal may not be negative or zero");
        }
        this.selectInterval = selectInterval;
    }

    public long getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public void setShutdownGracePeriod(long gracePeriod) {
        if (gracePeriod <= 0L) {
            throw new IllegalArgumentException("Shutdown grace period may not be negative or zero");
        }
        this.shutdownGracePeriod = gracePeriod;
    }

    public boolean isInterestOpQueued() {
        return this.interestOpQueued;
    }

    public void setInterestOpQueued(boolean interestOpQueued) {
        this.interestOpQueued = interestOpQueued;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public void setIoThreadCount(int ioThreadCount) {
        if (ioThreadCount <= 0) {
            throw new IllegalArgumentException("I/O thread count may not be negative or zero");
        }
        this.ioThreadCount = ioThreadCount;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public void setSoReuseAddress(boolean soReuseAddress) {
        this.soReuseAddress = soReuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public void setSoLinger(int soLinger) {
        this.soLinger = soLinger;
    }

    public boolean isSoKeepalive() {
        return this.soKeepAlive;
    }

    public void setSoKeepalive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSndBufSize() {
        return this.sndBufSize;
    }

    public void setSndBufSize(int sndBufSize) {
        this.sndBufSize = sndBufSize;
    }

    public int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public void setRcvBufSize(int rcvBufSize) {
        this.rcvBufSize = rcvBufSize;
    }

    protected IOReactorConfig clone() throws CloneNotSupportedException {
        return (IOReactorConfig)super.clone();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[selectInterval=").append(this.selectInterval).append(", shutdownGracePeriod=").append(this.shutdownGracePeriod).append(", interestOpQueued=").append(this.interestOpQueued).append(", ioThreadCount=").append(this.ioThreadCount).append(", soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", connectTimeout=").append(this.connectTimeout).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append("]");
        return builder.toString();
    }
}

